/*------------------------------------------------------------------------------*
 * File Name: EasyLR.c		 													*
 * Creation: GJL 7/17/03														*
 * Purpose: OriginC source file containing example usage of EasyLR class.		*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007				*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include <..\OriginLab\Stat_Utils.c>
#include <..\OriginLab\Stat_Utils.h>
#include "EasyFit.h"
#include "EasyLR.h"

// Demonstrate performing an easy linear regression
int DemoEasyLR()
{
	// Declare EasyLR object named elrDemo
	EasyLR elrDemo("Data1_A", "Data1_B");

	// Customize input settings
	elrDemo.Settings.ThroughZero.nVal = 1;           // Force fit to pass thru zero
	elrDemo.Settings.Confidence.dVal = 90;           // Set confidence level

	// Perform fit
	elrDemo.Fit();

	// Plot input and output curves
	elrDemo.PlotCurves();

	// Output results to Script window
	elrDemo.OutputResults("Easy Linear Regression Results");

	return 0;
}

// Demonstrate performing an easy linear regression with new and delete operators
int DemoEasyLRwithNew()
{
	EasyLR *pelrDemo = new EasyLR;
	pelrDemo->Attach("Data1_A", "Data1_B");

	// Perform fit
	pelrDemo->Fit();

	// Plot input and output curves
	pelrDemo->PlotCurves();

	// Output results to Script window
	pelrDemo->OutputResults("Easy Linear Regression Results");

	// Destroy EasyLR object pointed to by pelrDemo
	delete pelrDemo;

	return 0;
}